<?php
/**--------------------------------------
 * @package     ruxin_news - Ruxin News
 * @copyright   Copyright (C) 2020 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/
defined('_JEXEC') or die;

$show_intro_image = $params->get('show_intro_thumbnail', 1);
$intro_thumbnail_float = $params->get('intro_image_align', 'none');

$intro_thumbnail_width = $params->get('intro_thumbnail_width', '600');
$intro_thumbnail_height = $params->get('intro_thumbnail_height', '200');

$intro_column = $params->get('intro_column', 1);
$intro_items = array_slice($list, $lead_count, $intro_count);
$intro_text_type = $params->get('intro_text_type', 'news_on_image');

if (!$show_intro_image) $intro_text_type = 'news_normal';

$intro_title_size = $params->get('intro_title_size', 18);

$show_intro_title = $params->get('show_intro_title', 1);
$show_intro_intro = $params->get('show_intro_introtext', 0);
$intro_title_limit = $params->get('intro_title_limit', 120);
$intro_introtext_limit = $params->get('intro_introtext_limit', 120);

$show_intro_date = $params->get('show_intro_date', 'LC1');
$show_intro_hits = $params->get('show_intro_hits', 0);
$show_intro_cat = $params->get('show_intro_cat', 0);
$intro_cat_top = $params->get('intro_cat_top', 0);

$show_intro_author = $params->get('show_intro_author', 0);

$intro_title_weight = $params->get('intro_title_weight', 400);
$intro_image_count = 0;
$intro_width = $params->get('intro_width', '50%');

$intro_text_center = $params->get('intro_text_center', 0);

$intro_date_icon = ($intro_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/date.png" : JURI::root()."modules/mod_ruxin_news/includes/images/date-dark.png";
$intro_hits_icon = ($intro_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/hits.png" : JURI::root()."modules/mod_ruxin_news/includes/images/hits-dark.png";
$intro_author_icon = ($intro_text_type == "news_on_image") ? JURI::root()."modules/mod_ruxin_news/includes/images/author.png" : JURI::root()."modules/mod_ruxin_news/includes/images/author-dark.png";

$intro_show_read_more = $params->get('intro_show_read_more', 0);
$intro_read_more_text = $params->get('intro_read_more_text', 'Read More...');
$intro_read_more_color = $params->get('intro_read_more_color', '#c7c7c7');
$intro_read_more_font_size = $params->get('intro_read_more_font_size', '13px');

// Extra Fields
$intro_show_field = $params->get('intro_show_field', 0);
$intro_field_position = $params->get('intro_field_position', "before_title");
$intro_field_number = $params->get('intro_field_number', 0);
$intro_field_character_limit = $params->get('intro_field_character_limit', 80);
$intro_field_text = $params->get('intro_field_text', "");
?>

<div class="news-intro">

    <?php foreach (array_chunk($intro_items, $intro_column) as $posts_row) { ?>

        <div class="news-row">

            <?php foreach ($posts_row as $key => $item){ ?>

                <div class="ruxin-news-col-<?php echo $intro_column; ?>">

                    <div class="news-item">

                        <!-- Show image -->
                        <?php if ($show_intro_image) { ?>
                        <a href="<?php echo $item->link; ?>" class="title" itemprop="url">
                            <?php if ($intro_text_type == "news_on_image") { ?>
                                <div class="<?php echo $image_hover_effect; ?>">
                                    <img class="intro_news_image" src="<?php echo $images[$intro_image_count + $lead_count]['intro_thumb']; ?>" alt="<?php echo $item->title; ?>" style="height: <?php echo $intro_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_intro_cat && $intro_cat_top) { ?>
										<div class = "intro_category_top intro_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
								</div>
                            <?php } else if ($intro_thumbnail_float == "left") { ?>
                                <img class="intro_news_image float_left" src="<?php echo $images[$intro_image_count + $lead_count]['intro_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $intro_thumbnail_width;?>px; height: <?php echo $intro_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_intro_cat && $intro_cat_top) { ?>
										<div class = "intro_category_top intro_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
							<?php } else if ($intro_thumbnail_float == "right") { ?>
                                <img class="intro_news_image float_right" src="<?php echo $images[$intro_image_count + $lead_count]['intro_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $intro_thumbnail_width;?>px; height: <?php echo $intro_thumbnail_height;?>px;"/>
									<!-- Show Category -->
									<?php if ($show_intro_cat && $intro_cat_top) { ?>
										<div class = "intro_category_top intro_catid_<?php echo $item->catid; ?>">
											<a href="<?php echo $item->categoryLink; ?>">
												<?php echo $item->category_title; ?>
											</a>
										</div>
									<?php } ?>
							<?php } else { ?>
								<img class="intro_news_image float_none" src="<?php echo $images[$intro_image_count + $lead_count]['intro_thumb']; ?>" alt="<?php echo $item->title; ?>" style="width: <?php echo $intro_thumbnail_width;?>px; height: <?php echo $intro_thumbnail_height;?>px;"/>
							<?php } ?>
						</a>
							<!-- Show Category -->
							<?php if ($show_intro_cat && $intro_cat_top) { ?>
								<div class = "intro_category_top intro_catid_<?php echo $item->catid; ?>">
									<a href="<?php echo $item->categoryLink; ?>">
										<?php echo $item->category_title; ?>
									</a>
								</div>
							<?php } ?>
                        <?php } ?>

                        <?php if ($show_intro_title || $show_intro_intro || $show_intro_date || $show_intro_hits || $show_intro_cat || $show_intro_author) { ?>
                            
							<?php if ($intro_text_type == "news_on_image") { ?>
								<a href="<?php echo $item->link; ?>"><div class="link_on_image"></div></a>
							<?php } ?>
							
							<div class="item_description <?php echo $intro_text_type; ?>">

                                <!-- Show Category -->
                                <?php if ($show_intro_cat && !$intro_cat_top) { ?>
                                    <div class = "intro_category">
                                        <a href="<?php echo $item->categoryLink; ?>" class="intro_catid_<?php echo $item->catid; ?>">
                                            <?php echo $item->category_title; ?>
                                        </a>
                                    </div>
                                <?php } ?>

								<!-- Show Extra Field Before Title -->
								<?php if ($intro_show_field && $intro_field_position == "before_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$intro_field_number]->value)) {
											echo "<span class='intro_news_field'>{$intro_field_text} {$functions->trimText($fields[$intro_field_number]->value, $intro_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$intro_field_number]->value)) {
											echo "<span class='intro_news_field'>{$intro_field_text} {$functions->trimText($item_extra_fields[$intro_field_number]->value, $intro_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>
								
                                <!-- Show Title -->
                                <a href="<?php echo $item->link; ?>" class="intro_title" itemprop="url" style="font-size: <?php echo $intro_title_size; ?>px; font-weight: <?php echo $intro_title_weight; ?>;"><?php echo $functions->trimText($item->title, $intro_title_limit, "char", "..."); ?></a>

								<!-- Show Extra Field After Title -->
								<?php if ($intro_show_field && $intro_field_position == "after_title") {
									if ($source == "category") { //Joomla Field
										$fields = FieldsHelper::getFields('com_content.article', $item, true);
										if (!empty($fields[$intro_field_number]->value)) {
											echo "<span class='intro_news_field'>{$intro_field_text} {$functions->trimText($fields[$intro_field_number]->value, $intro_field_character_limit, "char", "...")}</span>"; 
										}
									} else { //K2 Field
										$item_extra_fields = json_decode($item->extra_fields);
										if (!empty($item_extra_fields[$intro_field_number]->value)) {
											echo "<span class='intro_news_field'>{$intro_field_text} {$functions->trimText($item_extra_fields[$intro_field_number]->value, $intro_field_character_limit, "char", "...")}</span>"; 
										}
									} 
								} ?>
								
                                <!-- Show Text -->
                                <?php if ($show_intro_intro) { ?>
                                    <p class="intro_introtext"><?php echo $functions->trimText($item->introtext, $intro_introtext_limit, "char", "..."); ?></p>
                                <?php } ?>

								<!-- Show Read More -->
								<?php if ($intro_show_read_more) { ?>
									<a href="<?php echo $item->link; ?>" class="intro_read_more" style="color: <?php echo $intro_read_more_color; ?>; font-size: <?php echo $intro_read_more_font_size; ?>;"><?php echo $intro_read_more_text; ?></a>
								<?php } ?>

								<div class="intro_date_hits_author">
									<!-- Show Date -->
									<?php if ($show_intro_date) { ?>
										<div class="intro_date">
											<img class="intro_date_icon" src="<?php echo $intro_date_icon; ?>"/>
											<time datetime="<?php echo $item->publish_up ?>" itemprop="datePublished">
												<?php echo JHtml::_('date', $item->publish_up, JText::_("DATE_FORMAT_$show_intro_date")); ?>
											</time>
										</div>
									<?php } ?>

									<!-- Show Hits -->
									<?php if ($show_intro_hits) { ?>
										<div class="intro_hits">
											<img class="intro_hits_icon" src="<?php echo $intro_hits_icon; ?>"/>
											<meta itemprop="interactionCount" content="UserPageVisits:<?php echo $item->hits; ?>"><?php echo $item->hits; ?>
										</div>
									<?php } ?>

									<!-- Show Joomla Author -->
									<?php if ($show_intro_author && $source == "category") { ?>
										<?php if (isset($item->author) && $item->author !== "" || isset($item->created_by_alias) && $item->created_by_alias !== "") { ?>
											<div class="intro_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="intro_author_icon" src="<?php echo $intro_author_icon; ?>"/>
												<?php if (isset($item->author)) echo $item->author; else echo $item->created_by_alias; ?>
											</div>
										<?php }
									} ?>
									
									<!-- Show K2 Author -->
									<?php if ($show_intro_author && $source == "k2_category") { ?>
										<?php if (isset($item->created_by)) { ?>
											<div class="intro_auhor" itemprop="author" itemtype="http://schema.org/Person">
												<img class="intro_author_icon" src="<?php echo $intro_author_icon; ?>"/>
												<?php $author = JFactory::getUser($item->created_by);
												echo $author->name; ?>
											</div>
										<?php }
									} ?>
								</div>

                            </div>
							
                        <?php } ?>

                    </div>
                </div>

            <?php $intro_image_count += 1;
            } ?>

        </div>
    <?php } ?>

</div>

<style>
    #ruxin_news_<?php echo $module->id ?> .news-intro {
        width: <?php echo $intro_width; ?>;
    }
	
	<?php if ($intro_text_center) { ?>
	#ruxin_news_<?php echo $module->id ?> .news-intro .item_description, #ruxin_news_<?php echo $module->id ?> .news-intro .intro_category {
		text-align: center;
		margin: 0 auto;
	}
	<?php } ?>
</style>

