<?php
/**--------------------------------------
 * @package     ruxin_news - Ruxin News
 * @copyright   Copyright (C) 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 * ---------------------------------------**/


//Restrict direct access
defined('_JEXEC') or die('Restricted access');

class modRuxinNewsHelper
{

    public static function getList(&$params)
    {

        //Get source form params
        $source = $params->get('source', 'category');

        if ($source == 'category') {
            $source = 'joomla';
        } else {
            $source = 'k2';
        }

        $path = JPATH_SITE . '/modules/mod_ruxin_news/classes/' . $source . ".php";
        require_once $path;
        $className = "Ruxin" . $source . "ContentSource";
        $object = new $className($params);
        $items = $object->getList();
        return $items;

    }
	
	public static function loadmoreAjax(){

        $app = JFactory::getApplication();
        $jinput = $app->input;

        $config = new stdClass();

        $config->limit = $jinput->get('limit');
        $config->limitstart = $jinput->get('limitstart');
        $config->total = $jinput->get('total');
        $config->moduleID = $jinput->get('moduleid');

        $config->params = self::getParams($config->moduleID);
        $params = $config->params;

        $module = new stdClass();
        $module->id = $config->moduleID;
        $module->module = 'mod_ruxin_news';

        require_once JPATH_SITE . '/modules/mod_ruxin_news/tmpl/blocks/blocks.php';
        require_once JPATH_SITE . '/modules/mod_ruxin_news/classes/functions.php';

        $list = self::getList($params);

        $layout = dirname(__FILE__) . '/tmpl/'.str_replace('_:','',$config->params->get('layout', 'default')).'.php';
        require ($layout);

        exit;

    }

    public static function getParams($id = null)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('m.*');
        $query->from('#__modules AS m');
        $query->where('id = '.$id);
        $db->setQuery($query);
        $module = $db->loadObject();

        if($module){
            $params = new JRegistry($module->params);
        }
        else {
            $params = new JRegistry();
        }

        return $params;
    }
	
}
